/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.event;

import com.dfdyz.epicacg.client.camera.CameraAnimation;
import com.dfdyz.epicacg.utils.MathUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="epicacg", value={Dist.CLIENT})
public class CameraEvents {
    private static float yawLock = 0.0f;
    private static Vec3 posLock = new Vec3(0.0, 0.0, 0.0);
    public static CameraAnimation currentAnim;
    private static int tick;
    private static int linkTick;
    private static int maxLinkTick;
    private static boolean isEnd;
    private static boolean linking;
    private static LivingEntity orginal;
    private static final Vec3 Vec3UP;
    private static float fovO;
    private static boolean isLockPos;
    private static CameraAnimation.Pose pose_;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void TransformCam(ViewportEvent.ComputeCameraAngles event) {
        CameraType cameraType = Minecraft.m_91087_().f_91066_.m_92176_();
        if (cameraType.m_90612_() || cameraType.m_90613_()) {
            return;
        }
        if (isEnd && !linking || currentAnim == null) {
            return;
        }
        if (orginal == null) {
            isEnd = true;
            linking = false;
            return;
        }
        if (orginal.m_213877_()) {
            isEnd = true;
            linking = false;
            return;
        }
        Camera camera = event.getCamera();
        double partialTicks = event.getPartialTick();
        if (linking) {
            CameraAnimation.Pose pose = pose_;
            float t = ((float)linkTick + (float)partialTicks) / (float)maxLinkTick;
            Vec3 Coord = orginal.m_20318_((float)partialTicks);
            Vec3 targetPos = camera.m_90583_();
            Vec3 lastFramePos = pose.pos.m_82524_((float)Math.toRadians(-yawLock - 90.0f)).m_82549_(isLockPos ? posLock : Coord);
            Vec3 targetRelate = targetPos.m_82546_(Coord);
            Vec3 lastRelate = lastFramePos.m_82546_(Coord);
            targetRelate = MathUtils.ToCylindricalCoordinate(targetRelate);
            lastRelate = MathUtils.ToCylindricalCoordinate(lastRelate);
            Vec3 camPos = MathUtils.LerpMinCylindrical(lastRelate, targetRelate, t);
            camPos = MathUtils.ToCartesianCoordinates(camPos).m_82549_(Coord);
            float tmp = event.getYaw() - (yawLock - pose.rotY);
            if ((tmp %= 360.0f) > 0.0f) {
                tmp = Math.abs(tmp -= 360.0f) > tmp + 360.0f ? tmp + 360.0f : tmp;
            }
            float _rot_y = yawLock - pose.rotY + tmp * t;
            float _rot_x = MathUtils.lerpBetween(pose.rotX, event.getPitch(), t);
            camera.m_90572_(_rot_y, _rot_x);
            camera.m_90584_(camPos.f_82479_, camPos.f_82480_, camPos.f_82481_);
            event.setYaw(_rot_y);
            event.setPitch(_rot_x);
        } else {
            CameraAnimation.Pose pose;
            pose_ = pose = currentAnim.getPose(((float)tick + (float)partialTicks) / 20.0f);
            Vec3 camPos = pose.pos.m_82524_((float)Math.toRadians(-yawLock - 90.0f)).m_82549_(isLockPos ? posLock : orginal.m_20318_((float)partialTicks));
            camera.m_90572_(yawLock - pose.rotY, pose.rotX);
            camera.m_90584_(camPos.f_82479_, camPos.f_82480_, camPos.f_82481_);
            event.setYaw(yawLock - pose.rotY);
            event.setPitch(pose.rotX);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void AnimateCamFov(ViewportEvent.ComputeFov event) {
        CameraType cameraType = Minecraft.m_91087_().f_91066_.m_92176_();
        if (cameraType.m_90612_() || cameraType.m_90613_()) {
            return;
        }
        if (isEnd && !linking || currentAnim == null) {
            return;
        }
        if (orginal == null) {
            isEnd = true;
            linking = false;
            return;
        }
        if (orginal.m_213877_()) {
            isEnd = true;
            linking = false;
            return;
        }
        double partialTicks = event.getPartialTick();
        if (linking) {
            CameraAnimation.Pose pose = pose_;
            float t = ((float)linkTick + (float)partialTicks) / (float)maxLinkTick;
            event.setFOV((double)((int)MathUtils.lerpBetween(pose.fov, fovO, t)));
        } else {
            CameraAnimation.Pose pose;
            pose_ = pose = currentAnim.getPose(((float)tick + (float)partialTicks) / 20.0f);
            event.setFOV((double)((int)pose.fov));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void Tick(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            if (!isEnd) {
                ++tick;
            }
            if (linking) {
                ++linkTick;
            }
        } else {
            return;
        }
        if (!isEnd && currentAnim != null && (float)tick / 20.0f >= CameraEvents.currentAnim.totalTime) {
            isEnd = true;
            linking = true;
            tick = 0;
            linkTick = 0;
        }
        if (linking && currentAnim != null && linkTick >= maxLinkTick) {
            isEnd = true;
            linking = false;
            linkTick = 0;
            tick = 0;
        }
    }

    public static void SetAnim(CameraAnimation anim, LivingEntity org, boolean lockOrgPos) {
        if (org instanceof Player) {
            if (!((Player)org).m_7578_()) {
                return;
            }
        } else {
            return;
        }
        orginal = org;
        yawLock = org.m_5675_(0.0f);
        posLock = org.m_20182_();
        linking = false;
        isEnd = false;
        tick = 0;
        linkTick = 0;
        maxLinkTick = 8;
        currentAnim = anim;
        isLockPos = lockOrgPos;
        fovO = ((Integer)Minecraft.m_91087_().f_91066_.f_92068_.m_231551_()).intValue();
    }

    static {
        tick = 0;
        linkTick = 0;
        maxLinkTick = 3;
        isEnd = true;
        linking = false;
        Vec3UP = new Vec3(0.0, 1.0, 0.0);
        fovO = 0.0f;
        isLockPos = false;
    }
}

